'use client'

import { motion } from 'framer-motion';
import Image from 'next/image';
import Navbar from '../../components/Navbar';
import { use } from 'react';

const hisStoryPost = {
    title: "How we met... His Story",
    excerpt: "A tale of patience, persistence, and perfect timing - from curious observer to soulmate, spanning nearly a decade of divine orchestration.",
    content: `
        <h2>The First Impression</h2>
        <p>Who is this petite, yellow-looking girl in high heels, and what makes her so different from the rest of us here? This was my first impression of Adaeze back in 2014, at Church 3:16, the youth fellowship of The Fountain of Life Church. She always arrived with an entourage of friends, many of whom I already knew, but she stood out in a way that piqued my curiosity.</p>

        <p>For three years, I couldn't shake the question of who she really was, though I'll admit it wasn't romantic back then, I was in a serious relationship.</p>

        <h2>The Divine Encounter</h2>
        <p>Fast forward to 2019, at Johnny Room Live II, held at Muri Okunola Park. I was assisting my Event planning mentor, MNA, with the production, which gave me an all-access tag. While moving around the venue, I spotted her, Adaeze. But this time, something was different. She was alone. It was the first time I'd ever seen her without a crew. I approached her and blurted out, "I know you." Looking back now, I think it was prophetic.</p>

        <p>We struck up a conversation, which started with me confirming her connection to our mutual friends, and ended with me discovering her love for Johnny Drille, so much so that she hoped he'd be part of her wedding someday. Before work pulled me away, I managed to ask for her number.</p>

        <h2>The First Date</h2>
        <p>Eight days later, I decided to take the plunge and invite her out, just to satisfy my curiosity. She said yes. On Sunday, November 10, 2019, we met at Circa Lagos. I got there early, as a proper gentleman, and made sure to check the menu prices in advance, Lagos big boys can't afford headline-worthy embarrassments.</p>

        <p>When she walked in, she was breathtaking, wearing a flowing blue gown with silver jewelry. But beyond her beauty, I was struck by her brilliance. Over mashed potatoes and ribs (hers) and pasta (mine), our conversation flowed effortlessly. She was insightful, knowledgeable, and genuine, a solid gold mind in a stunning package.</p>

        <blockquote>
            <p>That night, I journaled every detail. We hadn't discussed relationship statuses, so I assumed she was taken. A woman like that couldn't possibly be single.</p>
        </blockquote>

        <h2>Building the Foundation</h2>
        <p>Still, we kept in touch, and by year's end, I invited her to be my plus-one at a 2Face concert. It was such a great night that I ended up as her unofficial photographer until past midnight.</p>

        <p>Then came January 2, 2020. I learned she was in the hospital and dropped everything to visit her. Oddly enough, it was during that visit I became convinced she was in a relationship, thanks to the international calls she kept receiving. "Team LDR," I thought.</p>

        <p>In September 2020, during a frustrating day at work, she randomly called to check in on me. That single conversation lifted my spirits in ways I didn't expect, solidifying her spot as one of my top twenty influencers of that year.</p>

        <h2>Through the Storms</h2>
        <p>When her dad passed in June 2021, I visited to pay my respects and attended the wake service. It was during this period that I truly admired her resilience and grace. Shortly after, she shared her plans to pursue an MBA in the UK. While happy for her, I couldn't ignore the pang of disappointment, another amazing person lost to "japa." I decided to give her a book for her send-off: Nice Girls Don't Get the Corner Office. The thought of adding a "I like you" note popped up but couldn't act on it.</p>

        <p>We stayed in touch during her time in the UK, and one night, she reached out for help with a marketing assignment. I stayed up with her, and of course, she aced it. (The Bible says two are better than one, doesn't it?)</p>

        <h2>The Perfect Timing</h2>
        <p>In February 2023, she called to announce she was back in Nigeria. We spent the day together, and as the months passed, our friendship deepened. I finally asked her out in July, but she wasn't ready. Between the distance and her resolve to keep me in the friend zone, it felt like a lost cause.</p>

        <blockquote>
            <p>On December 25, 2023, after a magical night at Chike's concert at Hard Rock Cafe, she surprised me with the best Christmas gift: a "yes" to being my girlfriend.</p>
        </blockquote>

        <p>Nine months later, I proposed, knowing without a doubt that she wasn't just a friend but my perfect timing.</p>
    `,
    image: "/groom.jpg",
    author: "Bolaji",
    authorImage: "/groom.jpg",
    date: "14 Feb 2025"
}

const herStoryPost = {
    title: "How we met… Her Story",
    excerpt: "A serendipitous meeting at Johnny Drille's concert that led to a beautiful journey of love, patience, and divine orchestration.",
    content: `
        <h2>The Unexpected Beginning</h2>
        <p>It all began on November 2, 2019. A close friend invited me to Johnny Drille's second concert in Lagos, held at Muri Okunola Park. Being a big fan of Johnny's music and style, I couldn't pass up the chance to attend. Little did I know that the evening would begin a journey that would change my life forever.</p>

        <p>While soaking in the music and the vibrant atmosphere, a young man walked up to me. He introduced himself confidently, claiming he knew me, and mentioned that we once served in the same church. I was polite but sceptical, as I had no recollection of ever meeting him. However, as he began to name-drop my friends, Moji, Imisi, Maureen, Ahmed, Tracy, Olumide etc, and the ministries I was privileged to serve in at the time which amongst them was the Fountain of Life Church, I felt a sense of familiarity. His excitement was palpable, and his knowledge of me went beyond surface-level interactions, which made me curious.</p>

        <p>I couldn't help but smile and giggle at his knack for mentioning names and specific details that connected us. (Safe to say he had been stalking me secretly for a long time in church and outside church) When he asked for my number, I gave it to him, more out of politeness than intrigue, and quickly forgot about the encounter.</p>

        <h2>The Persistent Pursuit</h2>
        <p>To my surprise, a few days later, he reached out, suggesting we meet for a catch-up. I ignored the first attempt, but when he asked again, I reluctantly obliged out of courtesy, not curious about his intentions. That meeting at one of my favourite restaurants turned out to be unforgettable. Over a good meal, we talked about life, career aspirations, and everything in between. It laid the foundation for a budding friendship. He soon positioned himself as my accountability partner, although I didn't take it too seriously at first.</p>

        <blockquote>
            <p>"I'll look for you more this year. Wish me luck." - His words on January 1, 2020</p>
        </blockquote>

        <p>Admittedly, I ghosted him more than once. Yet, he refused to be ghosted. He stayed persistent, sending messages and checking in. One day, he sweetened the deal with VIP tickets to a TuFace concert. Being the live band enthusiast that I am, I couldn't resist.</p>

        <h2>A Turning Point</h2>
        <p>On January 1, 2020, after the concert, he said, "I'll look for you more this year. Wish me luck." I replied skeptically, "Look for me. How?" But the very next day, I was admitted to the hospital due to a health emergency. Upon hearing the news, he rushed to be by my bedside. That simple act of care touched me deeply.</p>

        <p>From then on, he continued to check in, but I remained firm in the "friend zone." Even during the lockdown, he made a few trips to my estate. We would sit in the garden, chatting as friends, sharing encouragement, and discussing our dreams and career challenges. His presence was always steady, but I was resolute in not giving him the wrong impression.</p>

        <h2>The Journey to Yes</h2>
        <p>In 2021, I decided to move to the UK. He kept checking on me, ensuring I was settled, and even helped me with my marketing project. His consistency never wavered.</p>

        <p>What I didn't see coming, however, was him asking me to be his girlfriend years later. I laughed it off and changed the subject every time. At that stage, I wasn't eager for a relationship, especially not with him. Yet, his patience, persistence, and unwavering determination slowly chipped away my defences.</p>

        <p>Over time, I began to see the man behind the persistence. His love was tender, steadfast, and reflective of God's grace in my life. He captured my heart most profoundly, sticking by me through thick and thin. He embodied God's love for me, a gift I never anticipated.</p>

        <h2>The Easiest Yes</h2>
        <p>When he finally asked me to be his wife, there wasn't a shred of doubt in my mind. Saying "yes" was the easiest decision I've ever made. I couldn't imagine life with anyone else but him.</p>

        <blockquote>
            <p>This love story, woven by divine orchestration, is one I'll treasure forever. I am over the moon to be doing life with you, my love. Here's to forever.</p>
        </blockquote>
    `,
    image: "/bride.jpg",
    author: "Adaeze",
    authorImage: "/bride.jpg",
    date: "14 Feb 2025"
}

export default function OurStoryPage({ params }: { params: Promise<{ slug: string }> }) {
    const { slug } = use(params)
    const activeStory = slug === 'his-story' ? hisStoryPost : herStoryPost;

    return (
        <main>
            <Navbar topPlacement={true} />

            <div className="mt-28 container mx-auto px-4 md:max-w-[1200px]  ">
                {/* Hero Image */}
                {/* <div className="relative w-full h-[400px] mb-8">
                    <Image
                        src={activeStory.image}
                        alt="Blog post hero image"
                        fill
                        className="object-cover brightness-90 rounded-2xl"
                    />
                </div> */}

                {/* Content Container */}
                <div className="px-2 md:px-20 ">
                    {/* Blog Header */}
                    <motion.div
                        initial={{ opacity: 0, y: 20 }}
                        animate={{ opacity: 1, y: 0 }}
                        className=" mb-12"
                    >
                        <h1 className="text-3xl font-script md:text-4xl mb-2 mt-6">
                            {activeStory.title}
                        </h1>
                        <div className="flex items-center justify-start gap-2 text-sm text-[#222222]/80">
                            <div className="flex items-center gap-2">
                                <Image
                                    src={activeStory.authorImage}
                                    alt={activeStory.author}
                                    width={32}
                                    height={32}
                                    className="rounded-full aspect-square object-cover"
                                />
                                <span>{activeStory.author}</span>
                            </div>
                            {/* <span>•</span>
                            <span>{activeStory.date}</span> */}
                        </div>
                    </motion.div>

                    {/* Blog Content */}
                    <motion.div
                        initial={{ opacity: 0 }}
                        animate={{ opacity: 1 }}
                        transition={{ delay: 0.2 }}
                        className="prose w-full mb-16"
                        dangerouslySetInnerHTML={{ __html: activeStory.content }}
                    >
                    </motion.div>
                </div>
            </div>
        </main>
    );
}